package net.bersus.selene.spring.form;

import java.beans.PropertyVetoException;
import java.io.Serializable;

import net.bersus.selene.clases.obj.Objeto;
import net.bersus.selene.interfaz.http.obj.LHObjeto;
import net.bersus.selene.util.Lista;
import net.bersus.selene.util.ParametrosSeleneLista;

import org.springframework.ui.Model;

public class Objmd1idForm implements Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = -1154979859705325690L;

	private Objeto objeto = new Objeto();
	private Objeto criterioSeleccionObjeto = new Objeto();
	private Lista objetos = new Lista();
	
	public Objmd1idForm () {
		super();
	}
	
	public void setModel (Model model) {
		this.objeto = (Objeto)model.asMap().get(LHObjeto.CTX_OBJETO);
		this.criterioSeleccionObjeto = (Objeto)model.asMap().get(LHObjeto.CTX_CRITERIO_SELECCION_OBJETO);
		this.objetos = (Lista)model.asMap().get(LHObjeto.CTX_OBJETOS);
	}

	public void toModel(Model model) throws PropertyVetoException {
		model.addAttribute(LHObjeto.CTX_OBJETO, this.objeto);
		model.addAttribute(LHObjeto.CTX_CRITERIO_SELECCION_OBJETO, this.criterioSeleccionObjeto);
		model.addAttribute(LHObjeto.CTX_OBJETOS, this.objetos);
	}

	public Objeto getObjeto() {
		return objeto;
	}

	public void setObjeto(Objeto objeto) {
		this.objeto = objeto;
	}

	public Objeto getCriterioSeleccionObjeto() {
		return criterioSeleccionObjeto;
	}

	public void setCriterioSeleccionObjeto(Objeto criterioSeleccionObjeto) {
		this.criterioSeleccionObjeto = criterioSeleccionObjeto;
	}

	public Lista getObjetos() {
		return objetos;
	}

	public void setObjetos(Lista objetos) {
		this.objetos = objetos;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("Objmd1idForm [");
		sb.append("objeto=");
		sb.append(objeto);
		sb.append("criterioSeleccionObjeto=");
		sb.append(criterioSeleccionObjeto);
		sb.append("objetos=");
		if (objetos != null && objetos.getParametro() != null) {
			ParametrosSeleneLista parlis = (ParametrosSeleneLista)objetos.getParametro();
			sb.append(parlis.getTotal());
			sb.append(" elementos");
		} else {
			sb.append(objetos);
		}
		sb.append("]");
		return sb.toString();
	}
}
