package net.bersus.selene.spring.controller;

import static org.springframework.web.bind.annotation.RequestMethod.GET;
import static org.springframework.web.bind.annotation.RequestMethod.POST;

import java.beans.PropertyVetoException;

import javax.naming.NamingException;
import javax.validation.Valid;

import net.bersus.selene.interfaz.http.obj.LHObjeto;
import net.bersus.selene.spring.form.Objmd1idForm;
import net.bersus.selene.util.Conexion;
import net.bersus.selene.util.Modelo;
import net.bersus.selene.util.SeleneException;
import net.bersus.selene.util.SeleneKeys;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttribute;

@Controller
public class ObjetoController {
    // Instancia del logger
    private static final Logger logger = LoggerFactory.getLogger(ObjetoController.class);
    
    @Autowired
	private PlatformTransactionManager transactionManager;
    
	@RequestMapping(value="/OBJMD1ID", method = GET)
	public String objmd1id(
			Objmd1idForm objmd1idForm,
	   		@SessionAttribute(SeleneKeys.CTX_CONEXION) Conexion conexion,
			Model model) 
			throws SeleneException, PropertyVetoException, NamingException {
		logger.debug("Vista: OBJMD1ID. Modelo de entrada: " + model.asMap().toString());
		
        // Transformar el modelo de Spring al modelo Selene
		Modelo modelo = new Modelo(model.asMap());
		
        LHObjeto objmHome = new LHObjeto();
        String evento = SeleneKeys.EVT_OK;
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Leyendo tipos de objeto");
        	evento = objmHome.leerTiposDeObjeto(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Leyendo subtipos de objeto");
        	evento = objmHome.leerSubtiposDeObjetoCriterioSeleccion(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Leyendo tipos de indicador lista");
        	evento = objmHome.leerTiposDeIndicadorLista(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Limpiando criterio de seleccion");
        	evento = objmHome.limpiarCriterioSeleccion(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        } else {
        	return "util/mensaje";
        }
        
		logger.debug("Vista: OBJMD1ID. Modelo de salida: " + model.asMap().toString());
        logger.debug("Vista: seleccionaObjeto");
        return "seleccionaObjeto";
	}
	
	@RequestMapping(value="/seleccionaObjeto", method = GET)
	public String seleccionaobjmd1idForm(Objmd1idForm objmd1idForm) {
		logger.debug("Entrando en el controlador GET de seleccionarObjeto");
		return "seleccionaObjeto";
	}
    
	@RequestMapping(value="/seleccionaObjeto", method = POST)
	public String seleccionaObjetoSubmit(
			@ModelAttribute Objmd1idForm objmd1idForm, 
	   		@SessionAttribute(SeleneKeys.CTX_CONEXION) Conexion conexion,
	   		BindingResult bindingResult,
			Model model) 
			throws SeleneException, PropertyVetoException, NamingException {
		logger.debug("Vista: seleccionaObjeto. Modelo de entrada: " + model.asMap().toString());
        if (bindingResult.hasErrors()) {
            return "seleccionarObjeto";
        }
        
        // Anadir el formulario al dato del contexto correspondiente
        objmd1idForm.toModel(model);

        // Transformar el modelo de Spring al modelo Selene
		Modelo modelo = new Modelo(model.asMap());
		
        LHObjeto objmHome = new LHObjeto();
        String evento = SeleneKeys.EVT_OK;
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Seleccionando");
        	evento = objmHome.seleccionar(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        	
        	// Transformar el modelo de Spring al formulario
        	objmd1idForm.setModel(model);
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Leyendo padres de objeto");
        	evento = objmHome.leerPadresObjeto(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        	
        	// Transformar el modelo de Spring al formulario
        	objmd1idForm.setModel(model);
        } else if (evento.equalsIgnoreCase(SeleneKeys.EVT_LISTA_VACIA)) {
        	return "util/mensaje";
        } else if (evento.equalsIgnoreCase(SeleneKeys.EVT_LISTA)) {
            model.addAttribute(objmd1idForm);
    		logger.debug("Vista: seleccionaObjeto. Modelo de salida: " + model.asMap().toString());
            logger.debug("Vista: listaObjetos");
        	return "listaObjetos";
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            model.addAttribute(objmd1idForm);
    		logger.debug("Vista: seleccionaObjeto. Modelo de salida: " + model.asMap().toString());
            logger.debug("Vista: consultarObjeto");
        	return "consultarObjeto";
        } else {
        	return "util/mensaje";
        }
	}
	
	@RequestMapping(value="/listaObjetos", method = GET)
	public String listaObjetos(Model model) 
			throws PropertyVetoException {
		Objmd1idForm objmd1idForm = new Objmd1idForm();
		objmd1idForm.setModel(model);
        model.addAttribute(objmd1idForm);
        return "listaObjetos";
	}
	
	@RequestMapping(value="/listaObjetos", method = POST)
	public String listaObjetos(
			@ModelAttribute Objmd1idForm objmd1idForm,
	   		@SessionAttribute(SeleneKeys.CTX_CONEXION) Conexion conexion,
			BindingResult bindingResult, 
			Model model) 
			throws SeleneException, PropertyVetoException, NamingException {
		logger.debug("Vista: listaObjetos. Modelo de entrada: " + model.asMap().toString());
        if (bindingResult.hasErrors()) {
            return "listaObjetos";
        }
        
        // Anadir el formulario al dato del contexto correspondiente
        objmd1idForm.toModel(model);

        // Transformar el modelo de Spring al modelo Selene
		Modelo modelo = new Modelo(model.asMap());
		
        LHObjeto objmHome = new LHObjeto();
        String evento = SeleneKeys.EVT_OK;
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Incluyendo");
        	evento = objmHome.incluir(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        	
        	// Transformar el modelo de Spring al formulario
        	objmd1idForm.setModel(model);
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Leyendo padres de objeto");
        	evento = objmHome.leerPadresObjeto(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        	
        	// Transformar el modelo de Spring al formulario
        	objmd1idForm.setModel(model);
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            model.addAttribute(objmd1idForm);
    		logger.debug("Vista: listaObjetos. Modelo de salida: " + model.asMap().toString());
            logger.debug("Vista: consultarObjeto");
        	return "consultarObjeto";
        } else {
        	return "util/mensaje";
        }
	}
    
	@RequestMapping(value="/consultarObjeto", method = GET)
	public String consultarObjeto(Model model) throws PropertyVetoException {
		Objmd1idForm objmd1idForm = new Objmd1idForm();
		objmd1idForm.setModel(model);
        model.addAttribute(objmd1idForm);
        return "consultarObjeto";
    }
	
	@RequestMapping(value="/consultarObjeto", method = POST)
	public String consultarObjeto(
			@Valid Objmd1idForm objmd1idForm, 
	   		@SessionAttribute(SeleneKeys.CTX_CONEXION) Conexion conexion,
			BindingResult bindingResult, 
			Model model) 
			throws SeleneException, PropertyVetoException, NamingException {
		logger.debug("Vista: consultarObjeto. Modelo de entrada: " + model.asMap().toString());
        if (bindingResult.hasErrors()) {
            return "seleccionarObjeto";
        }
        
        // Anadir el formulario al dato del contexto correspondiente
        objmd1idForm.toModel(model);

        // Transformar el modelo de Spring al modelo Selene
		Modelo modelo = new Modelo(model.asMap());
		
        LHObjeto objmHome = new LHObjeto();
        String evento = SeleneKeys.EVT_OK;
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            logger.debug("Obteniendo documentacion");
        	evento = objmHome.obtenerDocumentacion(modelo, conexion);
        	
        	// Transformar el modelo de Selene al modelo Spring
        	model.addAllAttributes(modelo.getElementos());
        	
        	// Transformar el modelo de Spring al formulario
        	objmd1idForm.setModel(model);
        } else {
        	return "util/mensaje";
        }
        if (evento.equalsIgnoreCase(SeleneKeys.EVT_OK)) {
            model.addAttribute(objmd1idForm);
    		logger.debug("Vista: consultarObjeto. Modelo de salida: " + model.asMap().toString());
            logger.debug("Vista: consultarObjeto");
        	return "consultarObjeto";
        } else {
        	return "util/mensaje";
        }
	}
}
